/*
 * Decompiled with CFR 0.152.
 */
package net.ftb.data;

import java.awt.Image;
import java.awt.Toolkit;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import net.ftb.data.ModPack;
import net.ftb.data.events.MapListener;
import net.ftb.gui.LaunchFrame;
import net.ftb.gui.panes.MapUtils;
import net.ftb.log.Logger;
import net.ftb.util.DownloadUtils;
import net.ftb.util.OSUtils;
import net.ftb.workers.MapLoader;

public class Map {
    private String name;
    private String author;
    private String version;
    private String url;
    private String mapname;
    private String mcversion;
    private String logoName;
    private String imageName;
    private String info;
    private String sep = File.separator;
    private String[] compatible;
    private Image logo;
    private Image image;
    private int index;
    private static final ArrayList<Map> maps = new ArrayList();
    private static List<MapListener> listeners = new ArrayList<MapListener>();

    public static void addListener(MapListener listener) {
        listeners.add(listener);
    }

    public static void loadAll() {
        MapLoader loader = new MapLoader();
        loader.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addMap(Map map) {
        ArrayList<Map> arrayList = maps;
        synchronized (arrayList) {
            maps.add(map);
        }
        for (MapListener listener : listeners) {
            listener.onMapAdded(map);
        }
    }

    public static ArrayList<Map> getMapArray() {
        return maps;
    }

    public static Map getMap(int i) {
        return maps.get(i);
    }

    public static Map getSelectedMap() {
        return Map.getMap(MapUtils.getSelectedMapIndex());
    }

    public Map(String name, String author, String version, String url, String logo, String image, String compatible, String mcversion, String mapname, String info, int idx) throws NoSuchAlgorithmException, IOException {
        this.index = idx;
        this.name = name;
        this.author = author;
        this.version = version;
        this.url = url;
        this.compatible = compatible.split(",");
        this.mcversion = mcversion;
        this.mapname = mapname;
        String installPath = OSUtils.getCacheStorageLocation();
        this.info = info;
        this.logoName = logo;
        this.imageName = image;
        File tempDir = new File(installPath, "Maps" + this.sep + mapname);
        File verFile = new File(tempDir, "version");
        if (!this.upToDate(verFile)) {
            DownloadUtils.saveImage(logo, tempDir, "png");
            DownloadUtils.saveImage(image, tempDir, "png");
        } else {
            if (!new File(tempDir, logo).exists()) {
                DownloadUtils.saveImage(logo, tempDir, "png");
            }
            if (!new File(tempDir, image).exists()) {
                DownloadUtils.saveImage(image, tempDir, "png");
            }
        }
        if (!new File(tempDir, logo).exists()) {
            logo = "logo_ftb.png";
            this.logoName = "logo_ftb.png";
            DownloadUtils.saveImage(logo, tempDir, "png");
        }
        this.logo = Toolkit.getDefaultToolkit().createImage(tempDir.getPath() + this.sep + logo);
        if (!new File(tempDir, image).exists()) {
            image = "default_splash.png";
            this.imageName = "default_splash.png";
            DownloadUtils.saveImage(image, tempDir, "png");
        }
        this.image = Toolkit.getDefaultToolkit().createImage(tempDir.getPath() + this.sep + image);
    }

    private boolean upToDate(File verFile) {
        boolean result = true;
        try {
            if (!verFile.exists()) {
                verFile.getParentFile().mkdirs();
                verFile.createNewFile();
                result = false;
            }
            BufferedReader in = new BufferedReader(new FileReader(verFile));
            String line = in.readLine();
            int storedVersion = -1;
            if (line != null) {
                try {
                    storedVersion = Integer.parseInt(line);
                }
                catch (NumberFormatException e) {
                    Logger.logWarn("Automatically fixing malformed version file for " + this.name, e);
                    line = null;
                }
            }
            if (line == null || Integer.parseInt(this.version) > storedVersion) {
                BufferedWriter out = new BufferedWriter(new FileWriter(verFile));
                out.write(this.version);
                out.flush();
                out.close();
                result = false;
            }
            in.close();
        }
        catch (IOException e) {
            Logger.logError("Error while checking map version", e);
        }
        return result;
    }

    public int getIndex() {
        return this.index;
    }

    public String getName() {
        return this.name;
    }

    public String getAuthor() {
        return this.author;
    }

    public String getVersion() {
        return this.version;
    }

    public String getUrl() {
        return this.url;
    }

    public Image getLogo() {
        return this.logo;
    }

    public Image getImage() {
        return this.image;
    }

    public String[] getCompatible() {
        return this.compatible;
    }

    public String getSelectedCompatible() {
        return this.compatible[LaunchFrame.getSelectedMapInstallIndex()].trim();
    }

    public String getMcVersion() {
        return this.mcversion;
    }

    public String getMapName() {
        return this.mapname;
    }

    public String getInfo() {
        return this.info;
    }

    public String getLogoName() {
        return this.logoName;
    }

    public String getImageName() {
        return this.imageName;
    }

    public boolean isCompatible(String packName) {
        for (String aCompatible : this.compatible) {
            ModPack pack = ModPack.getPack(aCompatible);
            if (pack != null) {
                return pack.getName().equals(packName);
            }
            Logger.logDebug("Map is compatible with " + packName + " , but modpack not found");
        }
        return false;
    }
}

